import requests
import json
import pandas as pd

# Use case: search + download + csv

username = 'yourusername@abc.com'
password = 'yourpassword'
apikey = 'yourapikey'

# define csv file structure
data_all = pd.DataFrame(columns=["DossierID",
                                 "Name",
                                 "BusinessAddress",
                                 "ResidenceAddress1",
                                 "ResidenceAddress2",
                                 "ResidenceAddress3",
                                 "ResidenceAddress4",
                                 "ResidenceAddress5"])

# tracking search result pages, start with page 1, 2, 3, 4..
page = 1

# tracking number of rows to be stored in csv file
rowCount = 0

# limit number of rows to be stored in csv file
MAX_ROW_COUNT = 5

while True:

    print('............. Page {} .............'.format(page))

    try:
        # Post a search query
        body = {"locationType": "Residence,Business,Hometown",
                "countryID": 1,
                "networthMin": format(100000000),
                "tafMin": format(100000000),
                "page": page,
                "pageSize": 20,
                "orderBy": "networthLower",
                "sortDirection": "descending"
                }
        headers = {"username": username, "password": password, "apikey": apikey, "accept":"application/json"}
        url = "https://connect.wealthx.com/rest/v1/dossiers/search/advanced"
        r = requests.post(url, body, headers=headers, timeout=30)

        # Get the total# and found dossier IDs
        json_search = json.loads(r.text, encoding="UTF-8")

        if rowCount == 0 and json_search and json_search["searchResult"]["totalHits"]:
            print("Total number of dossiers found: {} ................".format(json_search["searchResult"]["totalHits"]))

        if not ("totalHits" in json_search["searchResult"]):
            print("End of search results")
            break

    except Exception as Error:
        print("Error : POST request to use advanced search: {}".format(Error))
        break

    try:
        # Iterating the search results returned from this page with dossier IDs
        for hit in json_search["searchResult"]["hits"]:

            try:
                # Call /dossiers endpoint of this dossier to get detailed dossier information by dossier id
                headers = {"username": username, "password": password, "apikey": apikey, "accept":"application/json"}
                url = "https://connect.wealthx.com/rest/v1/dossiers/" + str(hit["ID"])
                d = requests.get(url, headers=headers, timeout=30)

                # Retrieve dossier info
                json_dossier = json.loads(d.text, encoding="UTF-8")
                print("#{} - Dossier: {}, Name: {} {}".format(rowCount+1, json_dossier["profilebasic"]["ID"],
                                                              json_dossier["profilebasic"]["firstName"],
                                                              json_dossier["profilebasic"]["lastName"]))

                # Insert dossier info to Dataframe

                # Dossier ID and Name
                data_all._set_value(len(data_all)+1,"DossierID",json_dossier["profilebasic"]["ID"])
                data_all._set_value(len(data_all),"Name",' '.join([json_dossier["profilebasic"]["firstName"] if "firstName" in json_dossier["profilebasic"] else "",
                                                                   json_dossier["profilebasic"]["lastName"] if "lastName" in json_dossier["profilebasic"] else ""
                                                                   ]))

                # Business Address
                if json_dossier and json_dossier["profilebasic"]["businessContact"]:
                    data_all._set_value(len(data_all),"BusinessAddress",','.join([str(json_dossier["profilebasic"]["businessContact"]["street"])  if "street" in json_dossier["profilebasic"]["businessContact"] else "",
                                                                                  str(json_dossier["profilebasic"]["businessContact"]["city"]) if "city" in json_dossier["profilebasic"]["businessContact"] else "",
                                                                                  str(json_dossier["profilebasic"]["businessContact"]["state"]) if "state" in json_dossier["profilebasic"]["businessContact"] else "",
                                                                                  str(json_dossier["profilebasic"]["businessContact"]["zipcode"]) if "zipcode" in json_dossier["profilebasic"]["businessContact"] else "",
                                                                                  str(json_dossier["profilebasic"]["businessContact"]["country"]) if "country" in json_dossier["profilebasic"]["businessContact"] else ""]))

                # Residence Address
                if json_dossier and json_dossier["profilebasic"]["residences"]:
                    j = 1
                    for residence in json_dossier["profilebasic"]["residences"]:
                        if j <= 5:
                            data_all._set_value(len(data_all),"ResidenceAddress"+str(j),','.join([str(residence["city"]) if "city" in residence else "",
                                                                                                  str(residence["state"]) if "state" in residence else "",
                                                                                                  str(residence["zipcode"]) if "zipcode" in residence else "",
                                                                                                  str(residence["country"]) if "country" in residence else ""]))
                        j = j + 1

                # one row added
                rowCount = rowCount + 1

            except Exception as Error:
                print("Error : Get Request to get dossier info : {}".format(Error))

            if rowCount >= MAX_ROW_COUNT:
                break # exit this page

    except Exception as Error:
        print("Error : Iterating the search results returned from this page with dossier IDs : {}".format(Error))
        break

    # Limit number of rows to be stored in csv for demo purpose
    if rowCount >= MAX_ROW_COUNT:
        # stop navigating to next page
        break

        # Navigate to next page of search results
    page = page + 1

# Write the DataFrame to csv file
print("See output.csv for samples")
data_all.to_csv("output.csv",index=False,na_rep="NA")
